<?php
namespace AlloCine\OrmsBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

class DatabaseMigrateCommand extends Command
{
    use ContainerAwareTrait;

    /**
     * @required
     *
     * @param ContainerInterface $container
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    protected function configure()
    {
        $this->setName('orms:migrate:exec')
          ->setDescription('Exec migration script from <BasePath>/ModelBundle/Migration/');

        $this->addArgument('bundleName', InputArgument::REQUIRED, 'bundle name where the migration script is');
        $this->addArgument('scriptName', InputArgument::REQUIRED, 'file name to play for the migration');

        $this->addOption('action', 'a', InputOption::VALUE_REQUIRED, 'Action to execute (up or down)', 'up');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $bundleName      = $input->getArgument('bundleName');
        $bundle          = $this->container->get('kernel')->getBundle($bundleName);
        $bundleNamespace = $bundle->getNamespace();

        $migrationClass  = $bundleNamespace . '\Migration\migration' . $input->getArgument('scriptName');

        if (class_exists($migrationClass)) {
            $migration = new $migrationClass($this->container->get('service_container'));
            $method = $input->getOption('action');

            $output->writeln($migration->$method());
        } else {
            $output->writeln("<error> Class $migrationClass does not exists</error>");
        }

        return 0;
    }
}
