<?php

namespace AlloCine\OrmsBundle\Cache\Middleware;

use Orms\Middleware\QueryCacheInterface;
use Orms\Middleware\CacheResult;
use AlloCine\OrmsBundle\Cache\Driver\DriverInterface;

class QueryCache implements QueryCacheInterface
{
    /**
     * @var DriverInterface
     */
    protected $driver;

    /**
     * @param DriverInterface $driver
     */
    public function __construct(DriverInterface $driver)
    {
        $this->driver = $driver;
    }

    /**
     * @param array $params
     * @return mixed
     */
    public function handleGet(array $params)
    {
        return $this->driver->get($this->computeParams($params));
    }

    /**
     * @inheritdoc
     */
    public function handleSave(array $params, CacheResult $result)
    {
        return $this->driver->set($this->computeParams($params), $result);
    }

    /**
     * Create normalized cache key
     * @param array $params
     * @return string
     */
    protected function computeParams(array $params)
    {
        ksort($params);

        return md5(serialize($params));
    }
}
