<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Overblog\OrmsBundle\Logger;

use Symfony\Component\HttpKernel\Log\LoggerInterface;

/**
 * DbalLogger.
 */
class OrmsLogger
{
    protected $logger;

    /** @var array $queries Executed SQL queries. */
    public $queries = array();

    /** @var boolean $enabled If Debug Stack is enabled (log queries) or not. */
    public $enabled = true;

    public $start = null;

    public $currentQuery = 0;

    /**
     * Constructor.
     *
     * @param LoggerInterface $logger A LoggerInterface instance
     */
    public function __construct(LoggerInterface $logger = null)
    {
        $this->logger = $logger;
    }

    /**
     * {@inheritdoc}
     */
    public function startQuery($sql, array $params = null, array $types = null)
    {
        if ($this->enabled) {
            $this->start = microtime(true);
            $this->queries[++$this->currentQuery] = array('sql' => $sql, 'params' => $params, 'types' => $types, 'executionMS' => 0);
        }

        if (null !== $this->logger) {
            $this->log(substr($sql, 0, 1024));
        }
    }

    /**
     * {@inheritdoc}
     */
    public function stopQuery()
    {
        $this->queries[$this->currentQuery]['executionMS'] = microtime(true) - $this->start;
    }

    /**
     * Logs a message.
     *
     * @param string $message A message to log
     */
    public function log($message)
    {
        $this->logger->debug($message);
    }

    /**
     * Logs an exception
     *
     * @param string $message A message to log
     */
    public function logException($message)
    {
        $this->logger->err($message);
    }
}
