<?php
namespace AlloCine\OrmsBundle\Orms;

/**
 * Orm - Interface that every ORMs used in projet must implements
 * @author Xavier HAUSHERR
 */

interface ServiceInterface
{
    /**
     * Try to retrieve an object instance, or instanciate it from configuration
     * inject the provider
     */
    public function getObject($object, $param = null);

    /**
     * Return an object array based on search param
     */
    public function getObjects($object, $param = null);

    /**
     * Return an scalar based on search param to count objects
     */
    public function getNbObjects($object, $param = null);

    /**
     * Return a Metadata object based on the last query for objects
     */
    public function getMetaData($object);
}
