<?php

namespace AlloCine\OrmsBundle\Cache\Driver;

use AlloCine\OrmsBundle\Cache\Driver\DriverInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

class Memory implements DriverInterface
{
    /**
     * @var ParameterBag
     */
    private $memory;

    public function __construct()
    {
        $this->memory = new ParameterBag();
    }

    /**
     * @inheritdoc
     */
    public function delete($key)
    {
        return $this->memory->remove($key);
    }

    /**
     * @inheritdoc
     */
    public function get($key)
    {
        return $this->memory->has($key) ? $this->memory->get($key) : false;
    }

    /**
     * @inheritdoc
     */
    public function set($key, $value)
    {
        return $this->memory->set($key, $value);
    }
}
