<?php
namespace Overblog\OrmsBundle\Command;

use Overblog\OrmsBundle\Command\BaseCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;

class DatabaseMigrateListCommand extends BaseCommand
{
    protected function configure()
	{
        $this->setName('orms:migrate:list')
		  ->setDescription('List migration scripts from <BasePath>/ModelBundle/Migration/');

        $this->addOption('key', 'k', InputOption::VALUE_REQUIRED, 'Bundle search key', 'ModelBundle');
        $this->addOption('onlyBundle', null, InputOption::VALUE_REQUIRED, 'Run only script for this bundle');
	}

    protected function execute(InputInterface $input, OutputInterface $output)
	{
        foreach($this->getBundlesToRun($input) as $name => $bundle)
        {
            $output->writeln(sprintf('<info>Found bundle %s</info>', $name));

            $fixturesPath    = $bundle->getPath()."/Migration/";

            if (!file_exists($fixturesPath))
            {
                $output->writeln("<error>No migration found in $fixturesPath </error>");
                continue;
            }

            foreach (Finder::create()->files()->name('migration_*.php')->sortByName()->in($fixturesPath) as $fixturesFile)
            {
                $output->writeln('<info>' . str_replace('migration_', '', basename($fixturesFile, '.php')) . '</info>');
            }
        }
    }
}

