<?php
namespace Overblog\OrmsBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DatabaseMigrateCommand extends ContainerAwareCommand
{
    protected function configure()
	{
        $this->setName('orms:migrate:exec')
		  ->setDescription('Exec migration script from <BasePath>/ModelBundle/Migration/');

        $this->addArgument('bundleName', InputArgument::REQUIRED, 'bundle name where the migration script is');
        $this->addArgument('scriptName', InputArgument::REQUIRED, 'file name to play for the migration');

        $this->addOption('action', 'a', InputOption::VALUE_REQUIRED, 'Action to execute (up or down)', 'up');
	}

    protected function execute(InputInterface $input, OutputInterface $output)
	{
        $bundleName      = $input->getArgument('bundleName');
        $bundle          = $this->getContainer()->get('kernel')->getBundle($bundleName);
        $bundleNamespace = $bundle->getNamespace();

        $migrationClass  = $bundleNamespace . '\Migration\migration_' . $input->getArgument('scriptName');

        if(class_exists($migrationClass))
        {
            $migration = new $migrationClass($this->getContainer()->get('service_container'));
            $method = $input->getOption('action');

            $output->writeln($migration->$method());
        }
        else
        {
            $output->writeln("<error> Class $migrationClass does not exists</error>");
        }
    }
}

