<?php

namespace Overblog\OrmsBundle\Config;

/**
 * Object configuration class
 *
 * @author xavier
 */

use Symfony\Component\DependencyInjection\ContainerInterface;
use Orms\DataProvider\GenericDataProvider;
use Overblog\OrmsBundle\DependencyInjection\OverblogOrmsExtension as Extension;

class Object
{
    /**
     * Main service container instance
     * @var ContainerInterface
     */
    protected $container;

    /**
     * Provider instance
     * @var GenericDataProvider
     */
    protected $provider;

    /**
     * Model class Name
     * @var string
     */
    protected $object_class;

    /**
     * Table likns
     * @var array
     */
    protected $links = array();

    /**
     * Instanciate service
     * @param ContainerInterface $container
     * @param GenericDataProvider $provider
     * @param string $object_class
     * @param array $links
     */
    public function __construct(
        ContainerInterface $container,
        GenericDataProvider $provider,
        $object_class,
        $links
    )
    {
        $this->container = $container;
        $this->provider = $provider;
        $this->object_class = $object_class;
        $this->links = $links;
    }

    /**
     * Return provider
     * @return GenericDataProvider
     */
    public function getProvider()
    {
        return $this->provider;
    }

    /**
     * Return class
     * @return string
     */
    public function getClass()
    {
        return $this->object_class;
    }

    /**
     * Return links configuration
     * @return array
     */
    public function getLinks()
    {
        if(count($this->links) > 0)
        {
            foreach($this->links as $name => $link)
            {
                $service = $this->container->get(
                    sprintf(Extension::OBJECT_NAME, $name)
                );

                $this->links[$name]['targetClass'] = $service->getClass();
                $this->links[$name]['provider'] = $service->getProvider();

                //Add links
                if($service === $this)
                {
                    $this->links[$name]['links'] = array(
                        'targetClass' => $service->getClass(),
                        'provider' => $service->getProvider(),
                        'links' => $link
                    );
                }
                else
                {
                    $this->links[$name]['links'] = $service->getLinks();
                }
            }
        }

        return $this->links;
    }

    /**
     * Remove provider reference and links
     */
    public function __destruct()
    {
        unset($this->provider, $this->links);
    }
}

