<?php

namespace Overblog\OrmsBundle\Cache;

use Orms\Cache\CacheInterface;
use Orms\Cache\CacheKey;
use Predis\Client;

/**
 * Redis cache for Orms Objects with Master/Slave
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class RedisMasterSlave implements CacheInterface
{
    /**
     * Cache TTL
     */
    const TTL = 86400;

    /**
     * Redis master instance
     * @var Client
     */
    protected $redisMaster;

    /**
     * Redis slave instance
     * @var Client
     */
    protected $redisSlave;

    /**
     * Constructor
     * @param \Predis\Client $redisMaster
     * @param \Predis\Client $redisSlave
     */
    public function __construct(Client $redisMaster, Client $redisSlave)
    {
        $this->redisMaster = $redisMaster;
        $this->redisSlave = $redisSlave;
    }

    /**
     * Get ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return array($result, $metadata)
     */
    public function get(CacheKey $key)
    {
        return unserialize(
                $this->redisSlave->hmget(
                    $key->getKey(),
                    $key->getField()
                )[0]
            );
    }

    /**
     * Set ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @param mixed $value
     * @param mixed $metadata
     * @return boolean
     */
    public function set(CacheKey $key, $value, $metadata)
    {
        $set = $this->redisMaster->hmset(
                $key->getKey(),
                $key->getField(),
                serialize(array($value, $metadata))
            );

        $this->redisMaster->expire($key->getKey(), self::TTL);

        return $set;
    }

    /**
     * Delete ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return int
     */
    public function clean(CacheKey $key)
    {
        return $this->redisMaster->del($key->getKey());
    }
}
