<?php

namespace AlloCine\OrmsBundle\Form\Extension;

use Orms\Object\DataObject;
use AlloCine\OrmsBundle\Orms\Service as Orms;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\Extension\Core\Type\FormType;

/**
 * Automatically proxify every entity coming from a form.
 */
class OrmsFormExtension extends AbstractTypeExtension
{
    /**
     * @var Orms
     */
    private $orms;

    /**
     * @param Orms $orms
     */
    public function __construct(Orms $orms)
    {
        $this->orms = $orms;
    }

    /**
     * {@inheritdoc}
     */
    public function getExtendedType()
    {
        return FormType::class;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->addEventListener(FormEvents::SUBMIT, function (FormEvent $event) {
            $entity = $event->getData();

            if (!($entity instanceof DataObject)) {
                return;
            }

            $event->setData($this->orms->proxify($entity));
        });
    }
}
