<?php

namespace Overblog\OrmsBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('overblog_orms_bundle');

        $rootNode
            ->children()
                ->scalarNode('cache')->defaultNull()->end()
                ->arrayNode('connections')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('type')->isRequired()->end()
                            ->arrayNode('options')
                                ->children()
                                    // PG-MySQL
                                    ->scalarNode('host')->end()
                                    ->scalarNode('port')->end()
                                    ->scalarNode('dbname')->end()
                                    ->scalarNode('username')->end()
                                    ->scalarNode('password')->end()
                                    // MySQL
                                    ->scalarNode('charset')->defaultValue('utf8')->end()
                                    // Ryak
                                    ->scalarNode('host')->end()
                                    ->scalarNode('port')->end()
                                    ->scalarNode('prefix')->end()
                                    ->scalarNode('mapred_prefix')->end()
                                    // SolR
                                    ->scalarNode('hostname')->end()
                                    ->scalarNode('port')->end()
                                    ->scalarNode('path')->end()
                                    ->scalarNode('timeout')->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('providers')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('connection')->isRequired()->end()
                            ->scalarNode('provider_class')->isRequired()->end()
                            ->arrayNode('provider_options')
                                ->children()
                                    ->scalarNode('schema')->end()
                                    ->scalarNode('table')->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('objects')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('provider')->isRequired()->end()
                            ->scalarNode('object_class')->isRequired()->end()
                            ->arrayNode('links')
                                ->requiresAtLeastOneElement()
                                ->useAttributeAsKey('name')
                                ->prototype('array')
                                    ->children()
                                        ->arrayNode('params')
                                            ->useAttributeAsKey('name')
                                            ->prototype('scalar')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                            ->arrayNode('links_cache')
                                ->requiresAtLeastOneElement()
                                ->prototype('scalar')->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
            // Connection validation
            ->validate()
                ->ifTrue( function($v) {
                    foreach($v['providers'] as $provider)
                    {
                        if(!isset($v['connections'][$provider['connection']])) return true;
                    }

                    return false;
                })
                ->thenInvalid('Unknow connection in providers configuration.')
            ->end()
            // Provider validation
            ->validate()
                ->ifTrue( function($v) {
                    foreach($v['objects'] as $objects)
                    {
                        if(!isset($v['providers'][$objects['provider']])) return true;
                    }

                    return false;
                })
                ->thenInvalid('Unknow provider in objects configuration.')
            ->end()
            // Linked Cache Object Validation
            ->validate()
                ->ifTrue( function($v) {
                    foreach($v['objects'] as $objects)
                    {
                        if(count($objects['links_cache']) > 0)
                        {
                            foreach($objects['links_cache'] as $links)
                            {
                                if(
                                    !isset($v['objects'][$links]) or
                                    !isset($v['providers'][$v['objects'][$links]['provider']])
                                )
                                {
                                    return true;
                                }
                            }
                        }
                    }

                    return false;
                })
                ->thenInvalid('Unknow provider in links_cache configuration.')
            ->end()
            ->validate()
                ->always(function($v) {
                    $v['links_cache'] = array();

                    foreach($v['objects'] as $objects)
                    {
                        if(count($objects['links_cache']) > 0)
                        {
                            $v['links_cache'][$objects['object_class']] = array();

                            foreach($objects['links_cache'] as $links)
                            {
                                $provider = $v['objects'][$links]['provider'];

                                $v['links_cache'][$objects['object_class']][] = $v['providers'][$provider]['provider_class'];
                            }
                        }
                    }

                    return $v;
                })
            ->end();

        return $treeBuilder;
    }
}

