<?php

namespace Tests\Cache\Middleware;
use AlloCine\OrmsBundle\Cache\Driver\Memory;
use AlloCine\OrmsBundle\Cache\Middleware\QueryCache;
use Orms\Middleware\CacheResult;

class QueryCacheTest extends \PHPUnit_Framework_TestCase
{
    public function testSave()
    {
        $cache = new QueryCache(new Memory());
        $result = new CacheResult('object', 'metadata');
        $param = ['id' => 1];

        $this->assertFalse($cache->handleGet($param));

        $cache->handleSave($param, $result);

        $this->assertEquals($cache->handleGet($param), $result);
    }
}
