<?php
namespace AlloCine\OrmsBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;

/**
 * Description of BaseCommand
 *
 * @author xavier
 */
abstract class BaseCommand extends ContainerAwareCommand
{
    /**
     * Return bundles to run
     * @param InputInterface $input
     * @return array
     */
    protected function getBundlesToRun(InputInterface $input)
    {
        $bundleKey     = $input->hasOption('key') ? $input->getOption('key') : null;
        $onlyBundle    = $input->getOption('onlyBundle');

        $bundles = [];

        foreach ($this->getApplication()->getKernel()->getBundles() as $name => $bundle) {
            if (is_null($bundleKey) || (strpos($name, $bundleKey) !== false) &&
                (is_null($onlyBundle) || (!is_null($onlyBundle) && $onlyBundle == $name))
            ) {
                $bundles[$name] = $bundle;
            }
        }
        return $bundles;
    }
}
