<?php

namespace Tests\AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Filter\ResizeFilter;

class ResizeTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @return array
     */
    public function resizeFilterSuccessProvider()
    {
        return [
            [
                10,
                10,
                'r_10_10'
            ]
        ];
    }

    /**
     * @dataProvider resizeFilterSuccessProvider
     *
     * @param $width
     * @param $height
     * @param $expectedToString
     */
    public function testResizeFilterSuccess($width, $height, $expectedToString)
    {
        $resizeFilter = new ResizeFilter($width, $height);

        $this->assertEquals($expectedToString, (string) $resizeFilter);
    }

    /**
     * @return array
     */
    public function resizeFilterConfigurationExceptionProvider()
    {
        return [
            [
                'a',
                0
            ],
            [
                0,
                'a'
            ],
        ];
    }

    /**
     * @dataProvider resizeFilterConfigurationExceptionProvider
     *
     * @param $width
     * @param $height
     */
    public function testResizeFilterConfigurationException($width, $height)
    {
        $this->setExpectedException('\InvalidArgumentException');

        new ResizeFilter($width, $height);
    }
}
