<?php

namespace Tests\AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Filter\CropFilter;

class CropTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @return array
     */
    public function cropFilterSuccessProvider()
    {
        return [
            [
                10,
                10,
                10,
                10,
                'c_10_10_10_10'
            ]
        ];
    }

    /**
     * @dataProvider cropFilterSuccessProvider
     *
     * @param $width
     * @param $height
     * @param $centerWidth
     * @param $centerHeight
     * @param $expectedToString
     */
    public function testCropFilterSuccess($width, $height, $centerWidth, $centerHeight, $expectedToString)
    {
        $cropFilter = new CropFilter($width, $height, $centerWidth, $centerHeight);

        $this->assertEquals($expectedToString, (string) $cropFilter);
    }
}
