<?php

namespace AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Exception\ConfigurationException;

class FormatFilter implements FilterInterface
{
    /**
     * Array of valid formats
     * @var array
     */
    const VALID_FORMATS = [ 'jpg', 'png', 'gif' ];

    private string $format;

    public function __construct(string $format)
    {
        $this->setFormat($format);
    }

    public function getFormat(): string
    {
        return $this->format;
    }

    public function setFormat(string $format): FormatFilter
    {
        if (! in_array($format, self::VALID_FORMATS)) {
            throw new ConfigurationException(
                "FormatFilter error. Provided format [$format] is invalid."
            );
        }

        $this->format = $format;

        return $this;
    }

    public function __toString(): string
    {
        return sprintf('f_%s', $this->getFormat());
    }

    public function getPriority(): int
    {
        return 0;
    }
}
