<?php

namespace AlloCine\ImageUrlGenerator\Filter;

class OverlayFilter implements FilterInterface
{
    private string $overlayFilename;

    private int $offset;

    private string $position;

    public function __construct(string $filename, int $offset, string $position)
    {
        $this->setOverlayFilename($filename);
        $this->setOffset($offset);
        $this->setPosition($position);
    }

    public function getOverlayFilename(): string
    {
        return $this->overlayFilename;
    }

    public function setOverlayFilename(string $filename): self
    {
        $this->overlayFilename = $filename;

        return $this;
    }

    public function getOffset(): int
    {
        return $this->offset;
    }

    public function setOffset(int $offset): self
    {
        $this->offset = $offset;

        return $this;
    }

    public function getPosition(): string
    {
        return $this->position;
    }

    public function setPosition(string $position): self
    {
        $this->position = $position;

        return $this;
    }

    public function __toString(): string
    {
        return sprintf('o_%s_%s_%s', $this->overlayFilename, $this->offset, $this->position);
    }

    public function getPriority(): int
    {
        return 40;
    }
}
