<?php

namespace AlloCine\ImageUrlGenerator;

class ConfigImageGenerator implements ConfigImageGeneratorInterface
{
    protected array $config;

    protected string $hostPattern = '%s.web.img%d.acsta.net';

    public function __construct(string $brand)
    {
        $this->config = constant(
            sprintf(
                '\AlloCine\ImageUrlGenerator\BrandConfig::%s',
                $brand
            )
        );
    }

    public function getPrefix(): string
    {
        return $this->config['prefix'];
    }

    public function getServerCount(): int
    {
        return $this->config['server_count'];
    }

    public function getHostPattern(): string
    {
        return $this->hostPattern;
    }
}
