<?php

namespace AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Exception\ConfigurationException;

class BorderFilter implements FilterInterface
{
    private int $width;

    private string $color;

    public function __construct(int $width, string $color = 'ffffff')
    {
        $this->setWidth($width);
        $this->setColor($color);
    }

    public function getWidth(): int
    {
        return $this->width;
    }

    public function setWidth(int $width): BorderFilter
    {
        if (!is_numeric($width)) {
            throw new \InvalidArgumentException('Width must be numeric');
        }

        $this->width = $width;

        return $this;
    }

    public function getColor(): string
    {
        return $this->color;
    }

    public function setColor(string $color): BorderFilter
    {
        $color = strtolower($color);

        if (!preg_match('/[a-f0-9]{6}/', $color)) {
            throw new ConfigurationException(sprintf(
                'Border error. "color" must be a valid hexadecimal color. "%s" given',
                $color
            ));
        }

        $this->color = $color;

        return $this;
    }

    public function __toString(): string
    {
        return sprintf('b_%s_%s', $this->width, $this->color);
    }

    public function getPriority(): int
    {
        return 30;
    }
}
