# The url generator for allocine images

## Usage

First, instantiate your image url as an object :

```php
use AlloCine\ImageUrlGenerator\ImageUrl;

$imageUrl = new ImageUrl('/newsv7/15/07/20/12/31/260214.jpg', 'fr', 6);
```

Here we prepare an image given its path and a subdomain ('fr'), but we also tell the generator that
we have 6 image servers that are used to load balance the images. The output domain should look like
one of :

- fr.web.img1.acsta.net
- fr.web.img2.acsta.net
- fr.web.img3.acsta.net
- fr.web.img4.acsta.net
- fr.web.img5.acsta.net
- fr.web.img6.acsta.net

For a given image path and servers amount the generated domain is always the same.

Now we want to apply some transformations (cropping, resizing) :

```php
$imageUrl
    ->resize(150, 150)
    ->crop(150, 150)
    ->border(2, 'FF0000')
    ->overlay('club300a.png', 0, 'se')
    ->format('png')
;
```

And then, all we have to do to show the image full url is to print the variable !

```php
echo (string) $imageUrl;
```

### Tests and coverage

To run the tests, you can use the following command :

```bash
docker-compose run php sh

composer install


$ ./vendor/bin/phpunit
```
