<?php

namespace Tests\AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Filter\FormatFilter;

class FormatFilterTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @return array
     */
    public function formatFilterSuccessProvider()
    {
        return [
            [ 'jpg', 'f_jpg' ],
            [ 'gif', 'f_gif' ],
            [ 'png', 'f_png' ],
        ];
    }

    /**
     * @dataProvider formatFilterSuccessProvider
     *
     * @param $format
     * @param $expectedToString
     */
    public function testFormatFilterSuccess($format, $expectedToString)
    {
        $formatFilter = new FormatFilter($format);

        $this->assertEquals($expectedToString, (string) $formatFilter);
    }
}
