<?php

namespace Tests\AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Filter\BorderFilter;

class BorderTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @return array
     */
    public function borderFilterSuccessProvider()
    {
        return [
            [
                10,
                'dadada',
                'b_10_dadada'
            ],
            [
                0,
                '6f6f6f',
                'b_0_6f6f6f'
            ]
        ];
    }

    /**
     * @dataProvider borderFilterSuccessProvider
     *
     * @param $width
     * @param $color
     * @param $expectedToString
     */
    public function testBorderFilterSuccess($width, $color, $expectedToString)
    {
        $borderFilter = new BorderFilter($width, $color);

        $this->assertEquals($expectedToString, (string) $borderFilter);
    }

    /**
     * @return array
     */
    public function borderFilterExceptionProvider()
    {
        return [
            ['da'],
            ['zazaza']
        ];
    }

    /**
     * @dataProvider borderFilterExceptionProvider
     *
     * @param $color
     */
    public function testBorderFilterException($color)
    {
        $this->setExpectedException('\AlloCine\ImageUrlGenerator\Exception\ConfigurationException');

        new BorderFilter(1, $color);
    }
}
