<?php

namespace AlloCine\ImageUrlGenerator\Filter;

class OverlayFilter implements FilterInterface
{
    /**
     * @var string
     */
    private $filename;

    /**
     * @var int
     */
    private $offset;

    /**
     * @var string
     */
    private $position;

    /**
     * @param string $filename
     * @param int    $offset
     * @param string $position
     */
    public function __construct(string $filename, int $offset, string $position)
    {
        $this->setOverlayFilename($filename);
        $this->setOffset($offset);
        $this->setPosition($position);
    }

    /**
     * @return string
     */
    public function getOverlayFilename(): string
    {
        return $this->overlayFilename;
    }

    /**
     * @param string $filename
     *
     * @return OverlayFilter
     */
    public function setOverlayFilename(string $filename): OverlayFilter
    {
        $this->overlayFilename = $filename;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset(): int
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     *
     * @return OverlayFilter
     */
    public function setOffset(int $offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return string
     */
    public function getPosition(): string
    {
        return $this->position;
    }

    /**
     * @param string $position
     *
     * @return OverlayFilter
     */
    public function setPosition(string $position): OverlayFilter
    {
        $this->position = $position;

        return $this;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return sprintf('o_%s_%s_%s', $this->overlayFilename, $this->offset, $this->position);
    }

    /**
     * @return int
     */
    public function getPriority(): int
    {
        return 40;
    }
}
