<?php

namespace Tests\AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Filter\OverlayFilter;

class OverlayTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @return array
     */
    public function overlayFilterSuccessProvider()
    {
        return [
            [
                'play.png',
                5,
                'se',
                'o_play.png_5_se'
            ]
        ];
    }

    /**
     * @dataProvider overlayFilterSuccessProvider
     *
     * @param $overlayFilename
     * @param $offset
     * @param $position
     * @param $expectedToString
     */
    public function testOverlayFilterSuccess($overlayFilename, $offset, $position, $expectedToString)
    {
        $overlayFilter = new OverlayFilter($overlayFilename, $offset, $position);

        $this->assertEquals($expectedToString, (string) $overlayFilter);
    }
}
