<?php

namespace AlloCine\ImageUrlGenerator;

class ConfigImageGenerator implements ConfigImageGeneratorInterface
{
    protected array $config;

    public function __construct(string $brand)
    {
        $this->config = constant(
            sprintf(
                '\AlloCine\ImageUrlGenerator\BrandConfig::%s',
                $brand
            )
        );
    }

    public function getPrefix(): string
    {
        return $this->config['prefix'];
    }

    public function getServerCount(): int
    {
        return $this->config['server_count'];
    }

    public function getPatternHost(): string
    {
        return '%s.web.img%d.acsta.net';
    }
}