<?php

namespace AlloCine\ImageUrlGenerator\Filter;

use AlloCine\ImageUrlGenerator\Exception\ConfigurationException;

class FormatFilter implements FilterInterface
{
    /**
     * Array of valid formats
     * @var array
     */
    const VALID_FORMATS = [ 'jpg', 'png', 'gif' ];

    /**
     * @var string
     */
    private $format;

    /**
     * @param string $format
     *
     * @throws ConfigurationException
     */
    public function __construct(string $format)
    {
        $this->setFormat($format);
    }

    /**
     * @return int
     */
    public function getFormat(): string
    {
        return $this->format;
    }

    /**
     * @param $width
     *
     * @return FormatFilter
     */
    public function setFormat(string $format): FormatFilter
    {
        if (! in_array($format, self::VALID_FORMATS)) {
            throw new ConfigurationException(
                "FormatFilter error. Provided format [$format] is invalid."
            );
        }

        $this->format = $format;

        return $this;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return sprintf('f_%s', $this->getFormat());
    }

    /**
     * @return int
     */
    public function getPriority(): int
    {
        return 0;
    }
}
