<?php

namespace AlloCine\I18NBundle\Command;

use AlloCine\I18NBundle\Translation\Manager;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Translation\Writer\TranslationWriter;

/**
 * Description of NormalizeTranslationsCommand
 *
 * @author Xavier HAUSHERR <xhausherr@allocine.fr>
 */
class NormalizeTranslationsCommand extends Command
{
    /**
     * @var TranslationWriter
     */
    private $writer;

    /**
     * @var ParameterBagInterface
     */
    private $parameterBag;

    /**
     * @var Manager
     */
    private $manager;

    public function __construct(ParameterBagInterface $parameterBag, TranslationWriter $writer, Manager $manager)
    {
        $this->parameterBag = $parameterBag;
        $this->writer = $writer;
        $this->manager = $manager;
        parent::__construct();
    }

    /**
     * {@inheritsDoc}
     */
    public function configure()
    {
        $this
            ->setName('translation:normalize')
            ->setDescription('Normalize xlf translation files.')
        ;
    }

    /**
     * {@inheritsDoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('Normalize translation keys for known brands.');

        foreach ($this->parameterBag->get('translation.ui.locales') as $locale) {
            $output->writeln(sprintf('<comment>Normalize %s.</comment>', $locale));
            $this->doExecute($locale);
        }

        $output->writeln('<info>Normalize complete.</info>');
    }

    /**
     * @param string   $locale
     * @param string[] $brands
     */
    private function doExecute($locale)
    {
        $path   = $this->parameterBag->get('translation.ui.path');

        $catalogue = $this->manager->getCatalogue($locale);

        $this->writer->disableBackup();
        $this->writer->write($catalogue, 'xlf', [
            'path'           => $path,
            'default_locale' => $this->parameterBag->get('translation.defaut.locale')
        ]);
    }
}
