<?php
/**
 * Created by PhpStorm.
 * User: yannick
 * Date: 15/09/2015
 * Time: 08:32
 */

namespace AlloCine\I18NBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Finder\Finder;
use AlloCine\I18NBundle\Translation\Loco;

class LocoImportCommand extends Command
{
    /**
     * @var Loco
     */
    private $loco;

    /**
     * @var ParameterBagInterface
     */
    private $parameterBag;

    public function __construct(ParameterBagInterface $parameterBag, Loco $loco)
    {
        $this->parameterBag = $parameterBag;
        $this->loco = $loco;
        parent::__construct();
    }

    /**
     * {@inheritsDoc}
     */

    public function configure()
    {
        $this
            ->setName('translation:loco:import')
            ->setDescription('Import all translation from xlf files to Loco.')
        ;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     */

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output = new SymfonyStyle($input, $output);
        $path   = $this->parameterBag->get('translation.ui.path');

        $output->title('Import all english translation from xlf files to Loco.');

        /** english first */

        $files = (new Finder())->sortByName()->in($path)->name('*.en_GB.xlf');

        foreach ($files as $file) {
            preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $match);

            $tag    = $match[1];
            $locale = $match[2];

            /* @var \SplFileInfo $file */
            $output->text($file->getFilename());
            $this->loco->import($file, $locale, $tag);
        }

        $output->title('Import all other translation from xlf files to Loco.');

        $files = (new Finder())->sortByName()->in($path)->notName('*.en_GB.xlf')->name('*.xlf');

        foreach ($files as $file) {
            preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $m);

            $tag    = $m[1];
            $locale = $m[2];

            /* @var \SplFileInfo $file */

            $output->text($file->getFilename());
            $this->loco->import($file, $locale, $tag);
        }
    }
}
