<?php

namespace AlloCine\I18NBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use AlloCine\I18NBundle\Form\Type\TranslationMessageType;

class TranslationDomainType extends AbstractType
{
    /**
     * {@inheritsDoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('messages', CollectionType::class, [
                'entry_type' => TranslationMessageType::class
            ])
        ;
    }

    /**
     * {@inheritsDoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(['data_class' => 'AlloCine\I18NBundle\Model\TranslationDomain']);
    }
}
