<?php

declare(strict_types=1);

namespace Tests\Translation;

use AlloCine\I18NBundle\Translation\LocoFormatter;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Finder\SplFileInfo;

final class LocoFormatterTest extends TestCase
{
    public function testFormat(): void
    {
        $xlf1 = __DIR__.'/Resources/test.fr_FR.xlf';
        $xlf2 = __DIR__.'/Resources/test.fr_FR_loco.xlf';

        $file1 = new SplFileInfo($xlf1, $xlf1, $xlf1);
        $file2 = new SplFileInfo($xlf2, $xlf2, $xlf2);

        $this->assertSame(LocoFormatter::format($file1->getContents()), $file2->getContents());
    }

    public function testUnformat(): void
    {
        $xlf1 = __DIR__.'/Resources/test.fr_FR.xlf';
        $xlf2 = __DIR__.'/Resources/test.fr_FR_loco.xlf';

        $file1 = new SplFileInfo($xlf1, $xlf1, $xlf1);
        $file2 = new SplFileInfo($xlf2, $xlf2, $xlf2);

        $this->assertSame(LocoFormatter::unformat($file2->getContents()), $file1->getContents());
    }
}
