<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Model;

class TranslationMessage
{
    public function __construct(private string $key, private string $value)
    {
    }

    public function getKey(): string
    {
        return $this->key;
    }

    public function setKey(string $key): static
    {
        $this->key = $key;

        return $this;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function setValue(string $value): static
    {
        $this->value = $value;

        return $this;
    }
}
