<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Model;

use AlloCine\I18NBundle\Translation\LocoFormatter;

class TranslationDomain
{
    public string $locale;

    private array $messages = [];

    public function __construct(private string $name, private readonly TranslationCatalogue $source)
    {
    }

    public function getSource(): TranslationCatalogue
    {
        return $this->source;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function setLocale(string $locale): static
    {
        $this->locale = $locale;

        return $this;
    }

    public function add(TranslationMessage $message): static
    {
        $this->messages[] = $message;

        return $this;
    }

    public function getMessages(): array
    {
        return $this->messages;
    }

    public function setMessages(array $messages): static
    {
        $this->messages = $messages;

        return $this;
    }

    public function getCompletion(): int|float
    {
        if (0 === $this->getTotalAmount()) {
            return 0;
        }

        return round(10000 * $this->getMissingAmount() / $this->getTotalAmount()) / 100;
    }

    public function getMissingAmount(): int
    {
        return \count(array_filter($this->messages, fn (TranslationMessage $message): bool => !empty($message->getValue()) && !str_starts_with($message->getValue(), LocoFormatter::PREFIX)));
    }

    public function getTotalAmount(): int
    {
        return \count($this->messages);
    }
}
