<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Extractor;

use AlloCine\I18NBundle\Translation\LocoFormatter;
use Symfony\Component\Translation\Extractor\ExtractorInterface;
use Symfony\Component\Translation\MessageCatalogue;

class AdvancedExtractor
{
    public function __construct(private readonly ExtractorInterface $extractor)
    {
    }

    public function extract(string $locale, array $paths): MessageCatalogue
    {
        $this->extractor->setPrefix(LocoFormatter::PREFIX);

        $extractedCatalogue = new MessageCatalogue($locale);

        foreach ($paths as $path) {
            $this->extractor->extract($path, $extractedCatalogue);
        }

        return $extractedCatalogue;
    }
}
