<?php

namespace AlloCine\I18NBundle\Model;

use Symfony\Component\Translation\MessageCatalogue;

class TranslationCatalogue extends MessageCatalogue
{
    /**
     * @param  string $name
     *
     * @return TranslationDomain
     */
    public function getDomain($name)
    {
        $domain = new TranslationDomain($name, $this);

        $all = $this->all($name);
        foreach ($all as $key => $value) {
            $domain->add(new TranslationMessage($key, $value));
        }

        return $domain;
    }

    /**
     * @param TranslationDomain $domain
     */
    public function addDomain(TranslationDomain $domain)
    {
        foreach ($domain->getMessages() as $message) {
            $this->set($message->getKey(), $message->getValue(), $domain->getName());
        }

        return $this;
    }

    /**
     * @return TranslationDomain[]
     */
    public function getAllDomains()
    {
        $domains = [];

        foreach ($this->getDomains() as $name) {
            $domains[]= $this->getDomain($name);
        }

        return $domains;
    }
}
