<?php

namespace AlloCine\I18NBundle\Model;

use AlloCine\I18NBundle\Translation\LocoFormatter;

class TranslationDomain
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var TranslationMessage[]
     */
    private $messages;

    /**
     * @var TranslationCatalogue
     */
    private $source;

    /**
     * @param string               $name
     * @param TranslationCatalogue $source
     */
    public function __construct($name, TranslationCatalogue $source)
    {
        $this->name     = $name;
        $this->source   = $source;
        $this->messages = [];
    }

    /**
     * @return TranslationCatalogue
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return TranslationDomain
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @param string $locale
     *
     * @return TranslationDomain
     */
    public function setLocale($locale)
    {
        $this->locale = $locale;

        return $this;
    }

    /**
     * @param TranslationMessage $message
     *
     * @return TranslationDomain
     */
    public function add(TranslationMessage $message)
    {
        $this->messages[] = $message;

        return $this;
    }

    /**
     * @return TranslationMessage[]
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * @param TranslationMessage[] $messages
     *
     * @return TranslationDomain
     */
    public function setMessages(array $messages)
    {
        $this->messages = $messages;

        return $this;
    }

    /**
     * @return float
     */
    public function getCompletion()
    {
        if ($this->getTotalAmount() == 0) {
            return 0;
        }

        return round(10000 * $this->getMissingAmount() / $this->getTotalAmount()) / 100;
    }

    /**
     * @return integer
     */
    public function getMissingAmount()
    {
        return count(array_filter($this->messages, function (TranslationMessage $message) {
            return !empty($message->getValue()) && !(strpos($message->getValue(), LocoFormatter::PREFIX) === 0);
        }));
    }

    /**
     * @return integer
     */
    public function getTotalAmount()
    {
        return count($this->messages);
    }
}
