<?php
/**
 * Created by PhpStorm.
 * User: yannick
 * Date: 15/09/2015
 * Time: 08:32
 */

namespace AlloCine\I18NBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\File\File;
use AlloCine\I18NBundle\Translation\Loco;

class LocoExportCommand extends Command
{
    /**
     * @var Loco
     */
    private $loco;

    /**
     * @var ParameterBagInterface
     */
    private $parameterBag;

    public function __construct(ParameterBagInterface $parameterBag, Loco $loco)
    {
        $this->parameterBag = $parameterBag;
        $this->loco = $loco;
        parent::__construct();
    }

    /**
     * {@inheritsDoc}
     */

    public function configure()
    {
        $this
            ->setName('translation:loco:export')
            ->setDescription('Export all translation from Loco.')
            ->addOption(
                'icu_format',
                null,
                InputOption::VALUE_OPTIONAL,
                'Use ICU messages format.',
                false
            )
        ;
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output = new SymfonyStyle($input, $output);
        $path = $this->parameterBag->get('translation.ui.path');

        /** @var Loco $loco */
        $tags = $this->loco->getTags();
        $locales = $this->loco->getLocales();

        $icuFormat = (bool) $input->getOption('icu_format');

        foreach ($locales as $locale => $realLocale) {
            foreach ($tags as $tag) {
                $export = $this->loco->export($realLocale, $tag);

                try {
                    $filePattern = $icuFormat ? '%s/%s+intl-icu.%s.xlf' : '%s/%s.%s.xlf';
                    $filename = sprintf($filePattern, $path, $tag, $locale);
                    $file = new File($filename);
                } catch (\Exception $e) {
                    $filename = sprintf('%s/%s.%s.xlf', $path, $tag, $realLocale);
                    $file = new File($filename);
                }

                $output->text($filename);

                $file->openFile('w')->fwrite($export);
            }
        }

    }
}
