<?php

namespace AlloCine\I18NBundle\Extractor;

use Symfony\Component\Translation\Extractor\ExtractorInterface;
use Symfony\Component\Translation\MessageCatalogue;
use AlloCine\I18NBundle\Translation\LocoFormatter;

class AdvancedExtractor
{
    /**
     * @var string
     */
    private $rootDir;

    /**
     * @var ExtractorInterface
     */
    private $extractor;

    /**
     * @param ExtractorInterface $extractor
     * @param string             $rootDir
     */
    public function __construct(ExtractorInterface $extractor)
    {
        $this->extractor = $extractor;
    }

    /**
     * @param string  $locale
     * @param string[] $paths
     *
     * @return MessageCatalogue
     */
    public function extract($locale, array $paths)
    {
        $this->extractor->setPrefix(LocoFormatter::PREFIX);

        $extractedCatalogue = new MessageCatalogue($locale);

        foreach($paths as $path) {
            $this->extractor->extract($path, $extractedCatalogue);
        }

        return $extractedCatalogue;
    }
}
