<?php

namespace AlloCine\I18NBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @var string
     */
    private $kernelProjectDir;

    /**
     * @param string $kernelProjectDir
     */
    public function __construct($kernelProjectDir)
    {
        $this->kernelProjectDir = $kernelProjectDir;
    }

    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('allo_cine_i18_n');
        $treeBuilder
            ->getRootNode()
            ->children()
                ->scalarNode('path')->defaultValue(sprintf('%s%s', $this->kernelProjectDir, '/translations'))->end()
                ->scalarNode('default_locale')->end()
                ->scalarNode('loco_api_key')->end()
                ->arrayNode('locales')
                    ->defaultValue(['en'])
                    ->prototype('scalar')->end()
                ->end()
                ->arrayNode('sourcePaths')
                    ->prototype('scalar')->end()
                ->end()
            ->end()
        ;
        return $treeBuilder;
    }
}
