<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Translation;

class LocoFormatter
{
    /**
     * Missing translation prefixer.
     */
    public const string PREFIX = 'missing__';

    /**
     * Remove <target> with missing translations.
     */
    public static function format(string $content): ?string
    {
        return preg_replace(
            '#<target>'.self::PREFIX.'[^<]+</target>#',
            '<target/>',
            $content
        );
    }

    /**
     * Add prefix target when target is empty.
     */
    public static function unformat(string $content): ?string
    {
        return preg_replace(
            '#(<source>([^<]+)</source>[^<]+)(<target></target>|<target/>)#m',
            '$1<target>'.self::PREFIX.'$2</target>',
            $content
        );
    }
}
