<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Model;

use Symfony\Component\Translation\MessageCatalogue;

class TranslationCatalogue extends MessageCatalogue
{
    public function getDomain(?string $name): TranslationDomain
    {
        $domain = new TranslationDomain($name, $this);

        $all = $this->all($name);
        foreach ($all as $key => $value) {
            $domain->add(new TranslationMessage($key, $value));
        }

        return $domain;
    }

    public function addDomain(TranslationDomain $domain): static
    {
        foreach ($domain->getMessages() as $message) {
            $this->set($message->getKey(), $message->getValue(), $domain->getName());
        }

        return $this;
    }

    public function getAllDomains(): array
    {
        $domains = [];

        foreach ($this->getDomains() as $name) {
            $domains[] = $this->getDomain($name);
        }

        return $domains;
    }
}
