<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Form\Type;

use AlloCine\I18NBundle\Model\TranslationMessage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TranslationMessageType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('value');
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['label'] = $form->getData()->getKey();
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults(['data_class' => TranslationMessage::class]);
    }
}
