<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\DependencyInjection;

use AlloCine\I18NBundle\Translation\Loco;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class AlloCineI18NExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration($container->getParameter('kernel.project_dir'));
        $config = $this->processConfiguration($configuration, $configs);

        $container->setParameter('translation.ui.locales', $config['locales']);
        $container->setParameter('translation.ui.path', $config['path']);
        $container->setParameter('translation.source.paths', $config['sourcePaths']);
        $container->setParameter('translation.default.locale', $config['default_locale']);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yaml');

        // Inject API key in loco
        $container->getDefinition(Loco::class)->replaceArgument(0, $config['loco_api_key']);
    }
}
