<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Command;

use AlloCine\I18NBundle\Translation\Manager;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Translation\Writer\TranslationWriter;

#[AsCommand(
    name: 'translation:normalize',
    description: 'Normalize xlf translation files.'
)]
class NormalizeTranslationsCommand extends Command
{
    public function __construct(
        private readonly ParameterBagInterface $parameterBag,
        private readonly TranslationWriter $writer,
        private readonly Manager $manager,
    ) {
        parent::__construct();
    }

    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->writeln('Normalize translation keys for known brands.');

        foreach ($this->parameterBag->get('translation.ui.locales') as $locale) {
            $output->writeln(\sprintf('<comment>Normalize %s.</comment>', $locale));
            $this->doExecute($locale);
        }

        $output->writeln('<info>Normalize complete.</info>');

        return Command::SUCCESS;
    }

    private function doExecute(string $locale): void
    {
        $path = $this->parameterBag->get('translation.ui.path');
        $catalogue = $this->manager->getCatalogue($locale);

        $this->writer->write($catalogue, 'xlf', [
            'path' => $path,
            'default_locale' => $this->parameterBag->get('translation.default.locale'),
        ]);
    }
}
