<?php

declare(strict_types=1);

namespace AlloCine\I18NBundle\Command;

use AlloCine\I18NBundle\Translation\Loco;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Finder\Finder;

#[AsCommand(
    name: 'translation:loco:import',
    description: 'Import all translation from xlf files to Loco',
)]
class LocoImportCommand extends Command
{
    public function __construct(private readonly ParameterBagInterface $parameterBag, private readonly Loco $loco)
    {
        parent::__construct();
    }

    public function configure(): void
    {
        $this
            ->setName('translation:loco:import')
            ->setDescription('Import all translation from xlf files to Loco.')
        ;
    }

    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $output = new SymfonyStyle($input, $output);
        $path = $this->parameterBag->get('translation.ui.path');

        $output->title('Import all english translation from xlf files to Loco.');

        /** english first */
        $files = (new Finder())->sortByName()->in($path)->name('*.en_GB.xlf');

        foreach ($files as $file) {
            preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $match);

            $tag = $match[1];
            $locale = $match[2];

            $output->text($file->getFilename());
            $this->loco->import($file, $locale, $tag);
        }

        $output->title('Import all other translation from xlf files to Loco.');

        $files = (new Finder())->sortByName()->in($path)->notName('*.en_GB.xlf')->name('*.xlf');

        foreach ($files as $file) {
            preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $m);

            $tag = $m[1];
            $locale = $m[2];

            $output->text($file->getFilename());
            $this->loco->import($file, $locale, $tag);
        }

        return Command::SUCCESS;
    }
}
