## —— Cloud run ————————————————————————————————————————————————————————————————————

# Parameters expected
# standard includes :
# - GCLOUD_PREFIX
# from .gitlab-ci.yml otherwise Makefile otherwise env:
# common :
# - GCP_LOCATIONS
# - IMPERSONATE
# - PRIMARY_LOCATION
# cloud run:
# - CLOUD_RUN_NAME
# - IMAGE_TAG
# - LIST_JOBS
# - REVISION_SWITCH
# - REVISION_TAG
# - URI_IMAGE_DOCKER
# - URI_JOB_DOCKER

RANDOM_REV := $(shell od -An -N2 -i /dev/random | tr -d ' ')
REVISION_SUFFIX=${IMAGE_TAG}-${RANDOM_REV}

.PHONY: update_image_jobs
update_image_jobs: gcloud_init ## update last image with IMAGE_TAG on LIST_JOBS cloud run jobs
	for location in `echo ${GCP_LOCATIONS}`; do \
	for jobid in `echo ${LIST_JOBS}`; do \
	echo "update job : "$${jobid} ${IMAGE_TAG} $${location}; \
	${GCLOUD_PREFIX} gcloud run jobs deploy $${jobid} --image ${URI_JOB_DOCKER}:${IMAGE_TAG} --region $${location} ${IMPERSONATE}; \
	done; \
	done;

.PHONY: deploy_main
deploy_main: gcloud_init ## deploy build with IMAGE_TAG
	for location in `echo ${GCP_LOCATIONS}`; do \
	${GCLOUD_PREFIX} gcloud run deploy \
	${CLOUD_RUN_NAME} --no-traffic ${IMPERSONATE} \
	--image ${URI_IMAGE_DOCKER}:${IMAGE_TAG} \
	--revision-suffix ${REVISION_SUFFIX} \
	--region $${location}; \
	${GCLOUD_PREFIX} gcloud run services update-traffic \
	${CLOUD_RUN_NAME} ${IMPERSONATE} \
	--to-latest \
	--region $${location}; \
	done;

.PHONY: deploy_qa
deploy_qa: gcloud_init ## deploy a qa with REVISION_TAG
	for location in `echo ${GCP_LOCATIONS}`; do \
	${GCLOUD_PREFIX} gcloud run deploy \
	${CLOUD_RUN_NAME} --no-traffic ${IMPERSONATE} \
	--image ${URI_IMAGE_DOCKER}:${IMAGE_TAG} \
	--revision-suffix ${REVISION_SUFFIX} \
	--region $${location}; \
	${GCLOUD_PREFIX} gcloud run services update-traffic \
	${CLOUD_RUN_NAME} ${IMPERSONATE} \
	--to-revisions ${CLOUD_RUN_NAME}-${REVISION_SUFFIX}=0 \
	--update-tags ${REVISION_TAG}=${CLOUD_RUN_NAME}-${REVISION_SUFFIX} \
	--region $${location}; \
	done;

.PHONY: switch_traffic
switch_traffic: gcloud_init ## switch traffic to version REVISION_SWITCH
	for location in `echo ${GCP_LOCATIONS}`; do \
	${GCLOUD_PREFIX} gcloud run services update-traffic \
        ${CLOUD_RUN_NAME} ${IMPERSONATE} \
	--to-revisions ${REVISION_SWITCH}=100 \
	--region $${location}; \
	done;

.PHONY: destroy_qa
destroy_qa: gcloud_init ## destroy qa version REVISION_TAG
	for location in `echo ${GCP_LOCATIONS}`; do \
	${GCLOUD_PREFIX} gcloud run services update-traffic \
	${CLOUD_RUN_NAME} ${IMPERSONATE} \
	--project ${GCP_PROJECT} --region $${location} \
	--remove-tags=${REVISION_TAG}; \
	done;
