<?php

namespace Tests\Translation;

use AlloCine\I18NBundle\Translation\LocoFormatter;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Finder\SplFileInfo;

/**
 * Description of LocoFormatterTest
 **/
class LocoFormatterTest extends TestCase
{
    public function testFormat()
    {
        $xlf1 = __DIR__ .  '/Resources/test.fr_FR.xlf';
        $xlf2 = __DIR__ .  '/Resources/test.fr_FR_loco.xlf';

        $file1 = new SplFileInfo($xlf1, $xlf1, $xlf1);
        $file2 = new SplFileInfo($xlf2, $xlf2, $xlf2);

        $this->assertEquals(LocoFormatter::format($file1->getContents()), $file2->getContents());
    }

    public function testUnformat()
    {
        $xlf1 = __DIR__ .  '/Resources/test.fr_FR.xlf';
        $xlf2 = __DIR__ .  '/Resources/test.fr_FR_loco.xlf';

        $file1 = new SplFileInfo($xlf1, $xlf1, $xlf1);
        $file2 = new SplFileInfo($xlf2, $xlf2, $xlf2);

        $this->assertEquals(LocoFormatter::unformat($file2->getContents()), $file1->getContents());
    }
}
