<?php

namespace AlloCine\I18NBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class AlloCineI18NExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration($container->getParameter('kernel.root_dir'));
        $config = $this->processConfiguration($configuration, $configs);

        $container->setParameter('translation.ui.locales', $config['locales']);
        $container->setParameter('translation.ui.path', $config['path']);
        $container->setParameter('translation.source.paths', $config['sourcePaths']);
        $container->setParameter('translation.defaut.locale', $config['default_locale']);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        // Inject API key in loco
        $container->getDefinition('loco')->replaceArgument(0, $config['loco_api_key']);
    }
}
