<?php

namespace AlloCine\I18NBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use AlloCine\I18NBundle\Form\Type\TranslationDomainType;

class DefaultController extends Controller
{
    public function indexAction()
    {
        return $this->render('AlloCineI18NBundle:Default:index.html.twig', [
            'catalogues' => $this->get('allocine.translation.manager')->getCatalogues(),
            'domains'    => $this->get('allocine.translation.manager')->getAvailableDomains()
        ]);
    }

    public function editAction(Request $request, $locale, $domain)
    {
        $manager = $this->get('allocine.translation.manager');

        $translationDomain = $manager->getCatalogue($locale)->getDomain($domain);
        $form = $this->createForm(TranslationDomainType::class, $translationDomain);

        if ($form->handleRequest($request)->isValid()) {
            $manager->saveDomain($translationDomain);
            $request->getSession()
                ->getFlashBag()
                ->add('success', 'All changes were saved.')
            ;
        }

        return $this->render('AlloCineI18NBundle:Default:edit.html.twig', [
            'catalogue' => $translationDomain->getSource(),
            'locale' => $locale,
            'domain' => $domain,
            'form' => $form->createView()
        ]);
    }
}
