<?php

namespace AlloCine\I18NBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Description of NormalizeTranslationsCommand
 *
 * @author Xavier HAUSHERR <xhausherr@allocine.fr>
 */
class NormalizeTranslationsCommand extends ContainerAwareCommand
{
    /**
     * {@inheritsDoc}
     */
    public function configure()
    {
        $this
            ->setName('translation:normalize')
            ->setDescription('Normalize xlf translation files.')
        ;
    }

    /**
     * {@inheritsDoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('Normalize translation keys for known brands.');

        foreach ($this->getContainer()->getParameter('translation.ui.locales') as $locale) {
            $output->writeln(sprintf('<comment>Normalize %s.</comment>', $locale));
            $this->doExecute($locale);
        }

        $output->writeln('<info>Normalize complete.</info>');
    }

    /**
     * @param string   $locale
     * @param string[] $brands
     */
    private function doExecute($locale)
    {
        $writer = $this->getContainer()->get('translation.writer');
        $path   = $this->getContainer()->getParameter('translation.ui.path');

        $catalogue = $this
            ->getContainer()
            ->get('allocine.translation.manager')
            ->getCatalogue($locale)
        ;

        $writer->disableBackup();
        $writer->writeTranslations($catalogue, 'xlf', [
            'path'           => $path,
            'default_locale' => $this->getContainer()->getParameter('translation.defaut.locale')
        ]);
    }
}
