<?php
/**
 * Created by PhpStorm.
 * User: yannick
 * Date: 15/09/2015
 * Time: 08:32
 */

namespace AlloCine\I18NBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\Finder\Finder;
use AlloCine\I18NBundle\Translation\Loco;

class LocoImportCommand extends ContainerAwareCommand
{
    /**
     * {@inheritsDoc}
     */

    public function configure()
    {
        $this
            ->setName('translation:loco:import')
            ->setDescription('Import all translation from xlf files to Loco.')
        ;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     */

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output = new SymfonyStyle($input, $output);
        $path   = $this->getContainer()->getParameter('translation.ui.path');

        /** @var Loco $loco */

        $loco = $this->getContainer()->get('loco');

        $output->title('Import all english translation from xlf files to Loco.');

        /** english first */

        $files = (new Finder())->sortByName()->in($path)->name('*.en_GB.xlf');

        foreach ($files as $file) {
            preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $match);

            $tag    = $match[1];
            $locale = $match[2];

            /* @var SplFileInfo $file */

            $output->text($file->getFilename());
            $loco->import($file, $locale, $tag);
        }

        $output->title('Import all other translation from xlf files to Loco.');

        $files = (new Finder())->sortByName()->in($path)->notName('*.en_GB.xlf')->name('*.xlf');

        foreach ($files as $file) {
            preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $m);

            $tag    = $m[1];
            $locale = $m[2];

            /* @var SplFileInfo $file */

            $output->text($file->getFilename());
            $loco->import($file, $locale, $tag);
        }
    }
}
